function phoneVerify(options)
{
    var _ = {};
    _.options = options;
    _.waiting = false;

    _.sendCode = function()
    {
        if (!_.waiting) {
            _.waiting = true;
            $.ajax({
                method: 'POST',
                url: _.options.sendCodeUrl,
                data: {},
                success: function(res)
                {
                    _.waiting = false;
                    _.startTimer(res.time_left)
                    _.showTimer();
                },
                error: function()
                {
                    _.waiting = false;
                }
            })
        }
    }

    _.onSendCode = function()
    {
        _.options.sendAgainBtn.on('click', function(e) {
            e.preventDefault()
            _.sendCode()
        })
    }

    _.showSendBtn = function()
    {
        _.options.sendAgainBtn.show();
        _.options.timerArea.hide();
    }

    _.showTimer = function()
    {
        _.options.sendAgainBtn.hide();
        _.options.timerArea.show();
    }

    _.timer = function()
    {

        _.now = new Date();
        var count = Math.round((_.timeup - _.now)/1000);
        if (_.now > _.timeup) {
            _.showSendBtn()
            clearInterval(_.counter);
            return;
        }
        var seconds = Math.floor((count%60));
        var minutes = Math.floor((count/60) % 60);
        _.options.timerSelect.html(minutes + ":" + seconds);
    }

    _.startTimer = function(seconds)
    {
        _.now = new Date();
        _.timeup = _.now.setSeconds(_.now.getSeconds() + seconds)
        _.counter = setInterval(_.timer, 1000);
    }

    _.init = function()
    {
        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });

        _.startTimer(_.options.timeLeft)
        _.onSendCode();
    }

    _.init();

    return _
}