function Shop(options) {
  var _ = {}

  _.totalFavorite = $('.js-total-favorite')

  _.toastifyMessage = (message, link) => {
    $('.toastify').remove()
    var nodeElement = document.createElement("div");
    nodeElement.innerHTML = '<i class="fa fa-check text-success"></i> ' + message;
    if (link !== undefined) {
      nodeElement.innerHTML += '<br><div class="text-center mt-3 mb-2"><a class="text-xs" href="' + link + '" class="btn btn-sm btn-yellow-darker">Перейти</a></div>'
    }

    Toastify({
      node: nodeElement,
      duration: 3000,
      stopOnFocus: true,
      destination: link,
      gravity: "bottom",
      position: "right",
      style: {
        background: "#051A32",
      }
    }).showToast();
  }

  _.favoriteAjax = (_this) => {
    $.ajax({
      url: options.favoriteUrl,
      headers: {
        'X-CSRF-Token': $('meta[name="csrf-token"]').attr('content')
      },
      method: 'POST',
      dataType: 'JSON',
      data: { id: _this.data('id') },
      success: function (data) {

        let message = data.message ?? "Успех !"
        if (data.status == 'false') {
          _this.data('favorite', false)
          _this.attr('data-favorite', false)
          _this.removeClass('active')
          _this.html("<svg data-v-b3e9397c=' viewBox='0 0 20 20' fill='none' xmlns='http://www.w3.org/2000/svg' alt='like' class='ui-icon '><path d='M5.95 2C8.51792 2 10 4.15234 10 4.15234C10 4.15234 11.485 2 14.05 2C16.705 2 19 4.07 19 6.95C19 11.1805 12.5604 15.6197 10.3651 17.5603C10.1582 17.7432 9.84179 17.7432 9.63488 17.5603C7.44056 15.6209 1 11.1803 1 6.95C1 4.07 3.295 2 5.95 2Z' fill='' fill-opacity='0.8'></path><path d='M1 6.86486C1 4.20297 3.15017 2 5.86486 2C7.98685 2 9.35921 3.35876 10 4.18673C10.6408 3.35876 12.0132 2 14.1351 2C16.8506 2 19 4.20302 19 6.86486C19 8.02987 18.5328 9.18622 17.8534 10.265C17.1716 11.3476 16.252 12.3903 15.29 13.3377C13.9567 14.6508 12.4757 15.8387 11.4134 16.6907C10.9618 17.0529 10.5859 17.3544 10.3293 17.579C10.1407 17.7439 9.85926 17.7439 9.67075 17.579C9.41405 17.3544 9.03815 17.0529 8.58659 16.6907C7.52431 15.8387 6.04326 14.6508 4.70997 13.3377C3.74802 12.3903 2.82836 11.3476 2.14659 10.265C1.46724 9.18622 1 8.02987 1 6.86486ZM5.86486 3C3.70929 3 2 4.74838 2 6.86486C2 7.76743 2.36553 8.73607 2.99277 9.73208C3.61759 10.7242 4.47833 11.706 5.41165 12.6252C6.71033 13.9042 8.08423 15.005 9.13396 15.8461C9.45728 16.1052 9.74985 16.3396 10 16.547C10.2501 16.3396 10.5427 16.1052 10.866 15.8461C11.9158 15.005 13.2897 13.9042 14.5883 12.6252C15.5217 11.706 16.3824 10.7242 17.0072 9.73208C17.6345 8.73607 18 7.76743 18 6.86486C18 4.74833 16.2914 3 14.1351 3C12.0406 3 10.8181 4.70211 10.5033 5.21028C10.2727 5.5825 9.72727 5.58249 9.4967 5.21027C9.1819 4.7021 7.95944 3 5.86486 3Z' fill='#e47600'></path></svg>")
         

          if (_this.data('favorite-remove')) {
            _this.closest('li').remove()
          }
          // _.toastifyMessage(message)

        } else {
          _this.data('favorite', true)
          _this.attr('data-favorite', true)
          _this.addClass('active')
          _this.html("<svg data-v-57aaf377='' viewBox='0 0 19 16' fill='none' xmlns='http://www.w3.org/2000/svg' class='ui-icon '><path d='M5.45 0.169434C8.01792 0.169434 9.5 2.32178 9.5 2.32178C9.5 2.32178 10.985 0.169434 13.55 0.169434C16.205 0.169434 18.5 2.23943 18.5 5.11943C18.5 9.34995 12.0604 13.7892 9.86509 15.7297C9.65819 15.9126 9.34179 15.9126 9.13488 15.7297C6.94056 13.7903 0.5 9.34976 0.5 5.11943C0.5 2.23943 2.795 0.169434 5.45 0.169434Z' fill='#e47600'></path></svg>")
          // _.toastifyMessage(message)
        }


        let total = isNaN(data.total) ? 0 : data.total;
        if (total > 0) {
          _.totalFavorite.removeClass('d-none')
          _.totalFavorite.addClass('d-flex')
        } else {
          _.totalFavorite.addClass('d-none')
          _.totalFavorite.removeClass('d-flex')
        }
        _.totalFavorite.html(total)
      }
    });
  }

  _.onAddToFavorite = () => {
    $(document).on('click', '[data-favorite]', function (e) {
      let _this = $(this)
      _.favoriteAjax(_this)
      e.preventDefault()
    })
  }

	_.onAddCart = () => {
		$(document).on('click', '.js-add-cart', function(e) {
			e.preventDefault();
			var _ = $(this),
					id = _.data('id')
			_.attr('disabled', true);
			$.ajax({
					type: "POST",
					url: options.addCartUrl,
					dataType: 'JSON',
					data: {
							id: id
					},
					success: function(data) {							
							setTimeout(function() {
									_.attr('disabled', false);
							}, 3000);
							if (data.status) {
									var nodeElement = document.createElement("div");
									nodeElement.className = "add-success"
									nodeElement.innerHTML = '<div><img src="' + data.product.img + '" alt="" />' +
											data.product.name +
											'</div><div><a class="text-xs" href="'+options.cartListUrl+'">'+options.toCart+'</a></div>';
									Toastify({
											node: nodeElement,
											duration: 2000,
											className: "add-cart",
											stopOnFocus: true,
											gravity: "top",
											position: "center",
											close: true,
											offset: {
													y: 15 // vertical axis - can be a number or a string indicating unity. eg: '2em'
											},
											style: {
													background: "#fff",
											}
									}).showToast();
									$('.js-cart-count').html(data.count)
							} else {
									_.attr('disabled', true)									
									Toastify({
											text: data.message,
											duration: 2000,
											className: "add-cart",
											gravity: "top",
											position: "center",
											close: true,
											offset: {
												y: 15 // vertical axis - can be a number or a string indicating unity. eg: '2em'
											}											
									}).showToast();
							}
					},
					error: function(ajaxContext) {
							alert(ajaxContext.responseText)
					}
			});
	})
	}


  _.initCsrf = () =>
  {
    $.ajaxSetup({
      headers: {
        'X-CSRF-Token': $('meta[name="csrf-token"]').attr('content')
      }
    });
  }

  _.init = () => {
    _.initCsrf()
    _.onAddToFavorite()
		_.onAddCart()
  }

  return _
}