function resetPassword(options)
{
    var _ = {};
    _.options = options;
    _.waiting = false;

		_.sendFormRequest = function(url,data)
		{			
				$.ajax({
					method: "POST",
					url: url,
					data: data,
					contentType: false,
					cache: false,
					processData: false
					}).done(function (data) {						
						_.cleanError()
						if (data.type == 'phone') {
							_.startTimer(data.time_left)
              _.showTimer();
						} else if (data.type == 'code') {
							Toastify({
								text: data.message,
								className: "toastify",
								duration: 8000,
								gravity: "top",
								position: "center",
								close: true,
								newWindow: true,
								style: {
									background: '#0643DA',
								}
							}).showToast()
							setTimeout(function(){location.href=data.url} , 1000);
						}						
					}).fail(function (response) {
						if (response.status == 422) {
							var res = JSON.parse(response.responseText)
							_.cleanError()
							$.each(res.errors, function (elem, item) {
								$.each(item, function (i, error) {										
									$('[name="' + elem + '"]').after('<label class="form-group__error">' + error + "</label>").parent().addClass("form-group--error")										
								})
							})
						} else {
							alert("Ошибка!")
						}					
				})			
		}

		_.onSendPhone = function()
		{
			_.options.sendPhoneBtn.on('click', function(e) {
				e.preventDefault()
				let data = new FormData($('form')[0]),
					url = _.options.sendFormUrl;
					data.append('type', 'phone')					
				_.sendFormRequest(url,data)
			})
		}

		_.onSendCodeBtn = function() {
			_.options.sendCodeBtn.on('click', function(e) {
				e.preventDefault()
				let data = new FormData($('form')[0]),
					url = _.options.sendFormUrl;
					data.append('type', 'code')					
				_.sendFormRequest(url,data)
			})
		}

    _.onSendCode = function()
    {
			_.options.sendAgainBtn.on('click', function(e) {
				e.preventDefault()
				let data = new FormData($('form')[0]),
					url = _.options.sendFormUrl;
					data.append('type', 'phone')					
				_.sendFormRequest(url,data)
			})
    }

    _.showSendBtn = function()
    {
			_.options.sendCodeContainer.show()
			_.options.sendAgainBtn.show()
			_.options.timerArea.hide()
    }

    _.showTimer = function()
    {
			_.options.sendAgainBtn.hide()
			_.options.timerArea.show()
			_.options.sendCodeContainer.show()
			_.options.sendPhoneBtn.hide()
    }

		_.cleanError = function() {
			$(".form-group__error").remove()
			$(".form-group--error").removeClass("form-group--error")
		}

    _.timer = function()
    {

        _.now = new Date();
        var count = Math.round((_.timeup - _.now)/1000);
        if (_.now > _.timeup) {
            _.showSendBtn()
            clearInterval(_.counter);
            return;
        }
        var seconds = Math.floor((count%60));
        var minutes = Math.floor((count/60) % 60);
        _.options.timerSelect.html(minutes + ":" + seconds);
    }

    _.startTimer = function(seconds)
    {
        _.now = new Date();
        _.timeup = _.now.setSeconds(_.now.getSeconds() + seconds)
        _.counter = setInterval(_.timer, 1000);
    }

    _.init = function()
    {
			$.ajaxSetup({
				headers: {
					'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
				}
			});
			_.startTimer(_.options.timeLeft)
			_.onSendCode();
			_.onSendPhone()
			_.onSendCodeBtn()
    }
    _.init();
    return _
}