$(document).ready(function() {
	var _body = $('body')
	$(".js-main-slider").slick({
		autoplay: true,
		dots: true,
		arrows:true,
		speed: 400
	});

	$(".js-main-car").slick({
		slidesToShow: 4,
		slidesToScroll: 1,
		autoplay: false,
		dots: false,
		arrows:true,
		speed: 500,
		prevArrow: $('.js-arrowl-car'),
	  nextArrow: $('.js-arrowr-car'),
		responsive: [
			{
				breakpoint: 992,
				settings: {
					slidesToShow: 3,
					dots: true,
				}
			},
			{
				breakpoint: 768,
				settings: {
					slidesToShow: 2,
					dots: true,
				}
			}
		]
	});

	$(".js-main-product").slick({
		slidesToShow: 5,
		slidesToScroll: 4,
		autoplay: true,
		dots: true,
		arrows:true,
		speed: 30000,
		prevArrow: $('.js-arrowl-product'),
		nextArrow: $('.js-arrowr-product'),
		responsive: [
			{
				breakpoint: 992,
				settings: {
					slidesToShow: 3,
					slidesToScroll: 2,
					arrows:false,
				}
			},
			{
				breakpoint: 768,
				settings: {
					slidesToShow: 2,
					slidesToScroll: 1,
					autoplay: false,
					arrows:false,
				}
			}
		]
	});

	$(".rateyo").each( function() {
			var _this = $(this),
					rating = $(this).attr("data-rating");
			if (_this.attr("data-comment-rating")) {
					rating = $(this).attr("data-comment-rating");
					_this.rateYo(
							{
									rating: rating,
									fullStar: true,
									ratedFill: '#2030771a',
									starWidth: '18px',
									readOnly: true,
									normalFill: "#2030771a",
							}
					);
			} else {
					_this.rateYo(
							{
									rating: rating,
									fullStar: true,
									ratedFill: '#FAC917',
									starWidth: '18px',
									readOnly: true,
									normalFill: "#D7D9DB",
							}
					);
			}
		});

	$(function () {
	  $(".js-rateyo").rateYo({
			rating: 4,
	    	starWidth: "18px",
	    	normalFill: "#D7D9DB",
	    	ratedFill: "#FAC917"
	  });
	});

	$('.js-minus').click(function () {
		var $input = $(this).parent().find('input');
		var count = parseInt($input.val()) - 1;
		count = count < 1 ? 1 : count;
		$input.val(count);
		$input.change();
		return false;
	});

	$('.js-plus').click(function () {
		var $input = $(this).parent().find('input');
		$input.val(parseInt($input.val()) + 1);
		$input.change();
		return false;
	});

	$('ul.tabs li').click(function(){
		var tab_id = $(this).attr('data-tab');

		$('ul.tabs li').removeClass('current');
		$('.tab-content').removeClass('current');

		$(this).addClass('current');
		$("#"+tab_id).addClass('current');
	})

	var is_animating = false;

	$('.js-login').on('click', function() {
		var _ = $(this);

		if (!is_animating) {
			is_animating = true
			if (_.hasClass('header__bottom-activ')) {
				_.removeClass('header__bottom-activ')
				// $('.js-login-modal').removeClass('show');
				$('.js-login-modal').fadeOut(200, function() {
					is_animating = false;
				});
			} else {
				_.addClass('header__bottom-activ')
				// $('.js-login-modal').removeClass('hide');
				$('.js-login-modal').fadeIn(200, function() {
					is_animating = false;
				});
			}
		}
	});

	_body.on('touchend click', function(e) {

        if ((e.type == 'touchend' || e.type == 'click') && !$(e.target).closest('.js-login-modal').length && !$(e.target).closest('.js-login').length) 
        {
            $('.js-login').removeClass('header__bottom-activ')
							// $('.js-login-modal').removeClass('show');
						$('.js-login-modal').fadeOut(200, function() {
							is_animating = false;
						});
        }
  });

	if ($(window).width() > 992) {
		$('.menu__nav-item').first().addClass('active');
		$('.menu__content-item').first().show();

			$('.menu__nav-item').mouseenter(function(){
				var tab_id = $(this).attr('data-menu');

				$('.menu__nav-item').removeClass('active');
				$('.menu__content-item').hide();

				$(this).addClass('active');
				$("#"+tab_id).fadeIn(300);
			});
	}
	else {
		$('.menu__nav-item').click(function(){
				$('.menu__nav-sub').slideUp();

				if($(this).hasClass('active')) {
					$(this).removeClass('active')
					$(this).find('.menu__nav-sub').slideUp();
				} else {
					$('.menu__nav-item').removeClass('active')
					$(this).addClass('active')
					$(this).find('.menu__nav-sub').slideDown();
				}
				
		});
	}


  var is_animating2 = false;

	$('.js-menu').on('click', function() {
		var _ = $('.hamburger');

		if (!is_animating2) {
			is_animating2 = true
			if (_.hasClass('open')) {
			 	$('.overlay').removeClass('open');
				$(this).removeClass('text-blue')
				_.removeClass('open')
				$('.menu').removeClass('open');
				_body.removeClass('o-hidden')
				
			} else {
			 	$('.overlay').addClass('open');
				$(this).addClass('text-blue')
				_.addClass('open')
				$('.menu').addClass('open');
				_body.addClass('o-hidden')
			}

			setTimeout(function() {
				is_animating2 = false;
			}, 300)
		}
	});

	_body.on('touchend click', function(e) {
        if ((e.type == 'touchend' || e.type == 'click') && !$(e.target).closest('.header').length) 
        {
					_body.removeClass('o-hidden')
					$('.overlay').removeClass('open');
					$('.js-menu').removeClass('text-blue')
					$('.hamburger').removeClass('open')
					$('.menu').removeClass('open');
        }
    });

		window.price_format = function(comma, period) {
        comma = comma || ',';
        period = period || '.';
        var split = this.toString().split('.');
        var numeric = split[0];
        var decimal = split.length > 1 ? period + split[1] : '';
        var reg = /(\d+)(\d{3})/;
        while (reg.test(numeric)) {
            numeric = numeric.replace(reg, '$1' + comma + '$2');
        }
        return numeric + decimal;
    }
});

