<?php

namespace Database\Seeders;

use App\Models\Role;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;

class RolesTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        DB::statement('SET FOREIGN_KEY_CHECKS=0;');
    	Role::truncate();
    	DB::statement('SET FOREIGN_KEY_CHECKS=1;');
		
    	foreach(config('authorization.roles') as $role)
    	{
    		Role::create($role);
    	}
    }
}
