<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateAddressesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('addresses', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('user_id')->unsigned();
            $table->integer('region_id')->unsigned();
            $table->integer('district_id')->unsigned();
            $table->string('street', 255);
            $table->string('house_number', 10);
            $table->string('floor', 10)->nullable();
            $table->string('entrance', 10)->nullable();
            $table->string('apartment', 10)->nullable();
            $table->boolean('main_address')->default(false);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('addresses');
    }
}
