<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateBlogsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('blogs', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('title_ru', 255);
            $table->string('title_uz', 255)->nullable();
            $table->string('short_text_ru', 255);
            $table->string('short_text_uz', 255)->nullable();
            $table->text('description_ru');
            $table->text('description_uz')->nullable();
            $table->text('meta_keywords_ru')->nullable();
            $table->text('meta_keywords_uz')->nullable();
            $table->text('meta_description_ru')->nullable();
            $table->text('meta_description_uz')->nullable();
            $table->string('alias', 255);
            $table->boolean('is_active')->default(false);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('blogs');
    }
}
