<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateProductsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('products', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('name_ru');
            $table->string('name_uz')->nullable();
            $table->string('short_description_ru',255);
            $table->string('short_description_uz',255)->nullable();
            $table->text('description_ru');
            $table->text('description_uz')->nullable();
            $table->decimal('price', 14, 0)->default(0);            
            $table->integer('discount')->nullable();            
            $table->boolean('to_1')->default(0);            
            $table->boolean('to_2')->default(0);            
            $table->string('meta_title_ru')->nullable();
            $table->string('meta_title_uz')->nullable();
            $table->string('meta_description_ru')->nullable();
            $table->string('meta_description_uz')->nullable();
            $table->integer('category_id')->nullable();
            $table->integer('manufacturer_id')->nullable();
            $table->string('alias');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('products');
    }
}
