<?php

namespace App\Rules;

use Illuminate\Contracts\Validation\Rule;

class Phone implements Rule
{
    /**
     * Create a new rule instance.
     *
     * @return void
     */
    public function __construct()
    {
        //
    }

    /**
     * Determine if the validation rule passes.
     *
     * @param  string  $attribute
     * @param  mixed  $value
     * @return bool
     */
    public function passes($attribute, $value)
    {
        $phone = preg_replace('/\D+/', '', $value);

        return strlen($phone) == 12 &&
            (substr($phone, 0, 3) == '998')
            && in_array(substr($phone, 3, 2), ['71', '33', '90', '93', '94', '91', '77', '95', '97', '98', '99', '88']);
    }

    /**
     * Get the validation error message.
     *
     * @return string
     */
    public function message()
    {
        return __('Неверный формат телефона.');
    }
}
