<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class SmsCode extends Model
{
    protected $guarded = [];

    public $dates = ['expires_at'];

    /**
     * Set the user's phone.
     *
     * @param  string  $value
     * @return void
     */
    public function setPhoneAttribute($value)
    {
        $this->attributes['phone'] = preg_replace('/[\+\-\(\)]/', '', $value);
    }
}
