<?php

namespace App\Models;
use Upload;

use Illuminate\Database\Eloquent\Model;

class Slider extends Model
{
    protected $guarded = [];
	protected $appends = ['image_ru', 'image_uz'];

	public function getImageRuAttribute()
	{
		return Upload::getFile('slider_ru', $this->id);
	}

	public function getImageUzAttribute()
	{
		return Upload::getFile('slider_uz', $this->id);
	}

	public function getUrlFormatAttribute()
	{
		return $this->{'url_'.app()->getLocale()};
	}

	public function getImageFormatAttribute()
	{
		if (Upload::hasFile('slider_'.app()->getLocale(), $this->id)) {
			return Upload::getFile('slider_'.app()->getLocale(), $this->id);
		}
		return asset('assets/images/321.jpg');
	}
}
