<?php

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Payment extends Model
{
    use HasFactory;
	protected $table = 'payments';

	public function getStatusAttribute()
	{
		$status = match ($this->state) {
			'pending' => 'Транзакция успешно создана, ожидание подтверждения',
			'commited' => 'Транзакция успешно завершена',
			'canceled' => 'Транзакция отменена',
			'canceled_after_commit' => 'Транзакция отменена после завершения',
		};
		return $status;
	}

	public function getCancelReasonAttribute()
	{
		$reason = match ($this->paycom_cancel_reason) {
			'-' => 'Не отменено',
			'receiver_not_found' => 'Один или несколько получателей не найдены или не активны в Paycom',
			'debit_processing_error' => 'Ошибка при выполнении дебетовой операции в процессингом центре',
			'transaction_error' => 'Ошибка выполнения транзакции',
			'by_timeout' => 'Отменена по таймауту',
			'cache_back' => 'Возврат денег',
			'unknown' => 'Неизвестная ошибка',
		};
		return $reason;	
	}

	public function getPaycomSystemTimeCreatedAttribute()
	{
		return Carbon::createFromTimestampMs($this->attributes['paycom_system_time_created'])->format('d-m-Y H:i:s');
	}

	public function getPaycomTimeCreatedAttribute()
	{
		return Carbon::createFromTimestampMs($this->attributes['paycom_time_created'])->format('d-m-Y H:i:s');
	}

	public function getPaycomTimePreformAttribute()
	{
		return Carbon::createFromTimestampMs($this->attributes['paycom_time_preform'])->format('d-m-Y H:i:s');
	}

	public function getPaycomTimeCanceledAttribute()
	{
		return Carbon::createFromTimestampMs($this->attributes['paycom_time_canceled'])->format('d-m-Y H:i:s');
	}
}
