<?php

namespace App\Models;

use App\Models\Product;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class OrderProduct extends Model
{
    use HasFactory;
	protected $guarded = [];
	protected $appends = ['total_cost_format'];

	public function product()
	{
		return $this->hasOne(Product::class, 'id', 'product_id');
	}

	public function getTotalCostFormatAttribute()
	{
		return number_format($this->total_cost, 0, ',', ' ');
	}	

	public function getOriginalPriceFormatAttribute()
	{
		return number_format($this->original_price, 0, ',', ' ');
	}

	public function getPriceFormatAttribute()
	{
		return number_format($this->price, 0, ',', ' ');
	}
}
