<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class OrderHistory extends Model
{
    use HasFactory;
	protected $guarded = [];

	public function order()
	{
		return $this->hasOne(Order::class, 'id', 'order_id');
	}

	public function user()
	{
		return $this->hasOne(User::class, 'id', 'user_id');
	}

	public function getStatusFormatAttribute()
	{
		return __('cabinet.order.statuses.'.$this->status);
	}

	public function getCreatedAtFormatAttribute()
	{
		return $this->created_at->format('d-m-Y H:i');
	}
}
