<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Casts\Attribute;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Order extends Model
{
    use HasFactory;
	protected $guarded = [];
	protected $appends = ['created_at_format', 'total_cost_format', 'status_label_format', 'status_format', 'delivery_type_format', 'full_name', 'payment_type_format'];

	public function getFullNameAttribute()
	{
		return $this->last_name.' '.$this->first_name;
	}

	public function products()
	{
		return $this->hasMany(OrderProduct::class, 'order_id', 'id');
	}
	
	public function getCreatedAtFormatAttribute()
	{
		return $this->created_at->format('d-m-Y H:i');
	}

	public function getTotalCostFormatAttribute()
	{
		return number_format($this->total_cost, 0, ',', ' ');
	}

	public function getStatusFormatAttribute()
	{
		return __('cabinet.order.statuses.'.$this->status);
	}

	public function payment()
	{
		return $this->hasOne(Payment::class, 'id', 'payment_id');
	}

	public function getStatusLabelFormatAttribute()
	{		
		$status = match ($this->status) {
			'pending' => '<label class="badge badge-primary">'.__('cabinet.order.statuses.'.$this->status).'</label>',
			'confirmed' => '<label class="badge badge-warning">'.__('cabinet.order.statuses.'.$this->status).'</label>',
			'paid' => '<label class="badge badge-success">'.__('cabinet.order.statuses.'.$this->status).'</label>',
			'shipping' => '<label class="badge badge-info">'.__('cabinet.order.statuses.'.$this->status).'</label>',
			'delivered' => '<label class="badge badge-success">'.__('cabinet.order.statuses.'.$this->status).'</label>',
			'canceled' => '<label class="badge badge-danger">'.__('cabinet.order.statuses.'.$this->status).'</label>',
		};
		return $status;
	}	

	public function getDeliveryTypeFormatAttribute()
	{
		return __('cabinet.order.delivery_types.'.$this->delivery_type);
	}

	public function getPaymentTypeFormatAttribute()
	{
		return __('cabinet.order.payment_types.'.$this->payment_type);
	}

	public function region()
	{
    	return $this->hasOne(Region::class, 'id', 'region_id');
    }

	public function district()
	{
    	return $this->hasOne(Region::class, 'id', 'district_id');
    }

	public function histories()
	{
		return $this->hasMany(OrderHistory::class, 'order_id', 'id');
	}

	public function getAddressFormatAttribute()
	{
		return $this?->region?->name.', '.$this?->district?->name.', '.$this->address;
	}	

	public function isOnlinePayment(): Attribute
	{
		return Attribute::make(
			get: fn ($value, $attributes) => in_array($attributes['payment_type'], ['payme','click','uzum'])
		);
	}
}


