<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Notification extends Model
{
	protected $guarded = [];
	protected $appends = ['created_at_format', 'text_format'];
	
    use HasFactory;

	public function getTextFormatAttribute()
	{
		return $this->{'text_'.app()->getLocale()};
	}

	public function user()
	{
		return $this->hasOne(User::class, 'id', 'user_id');
	}
	
	public function getCreatedAtFormatAttribute()
	{
		return $this->created_at->format('d-m-Y H:i');
	}
}
