<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Upload;

class Manufacturer extends Model
{
    protected $guarded = [];
	protected $appends = ['image'];

    // public function products()
    // {
    //     return $this->hasMany(Product::class, 'manufacturer_id', 'id');
    // }

	public function products()
    {
		return $this->belongsToMany(Product::class, 'product_manufacturer');
    }

    public function cars()
    {
        return $this->belongsToMany(Car::class, 'manufacturer_car');
    }

	public function getImageAttribute()
	{
		return Upload::getFile('manufacturer', $this->id);
	}

	public function getImageFormatAttribute()
	{
		if (Upload::hasFile('manufacturer', $this->id)) {
			return Upload::getFile('manufacturer', $this->id);
		}
		return asset('assets/images/chevrolet.png');
	}
}
