<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Upload;

class MainPage extends Model
{
    use HasFactory;

    protected $guarded = [];
	protected $appends = ['image_ru', 'image_uz'];

    public function category()
    {
        return $this->hasOne(Category::class, 'id', 'category_id');
    }

	public function getImageRuAttribute()
	{
		return Upload::getFile('main_page_ru', $this->id);
	}

	public function getImageUzAttribute()
	{
		return Upload::getFile('main_page_uz', $this->id);
	}

	public function getLinkFormatAttribute()
	{
		return $this->{'link_'.app()->getLocale()};
	}

	public function getImageFormatAttribute()
	{
		if (Upload::hasFile('main_page_'.app()->getLocale(), $this->id)) {
			return Upload::getFile('main_page_'.app()->getLocale(), $this->id);
		}
		return null;
	}

	public function getVideoFormatAttribute()
	{
		if (Upload::hasFile('main_page_video_'.app()->getLocale(), $this->id)) {
			return Upload::getFile('main_page_video_'.app()->getLocale(), $this->id);
		}
		return null;
	}
}
