<?php

namespace App\Models;
use Baum\Node;
use Upload;
/**
* Category
*/
class Category extends Node {

    protected $guarded = [];
	protected $appends = ['image'];

    public function getNameAttribute()
    {
        return $this->{'name_'.app()->getLocale()};
    }

    public function products()
    {
		return $this->belongsToMany(Product::class, 'product_category');
    }

	public function getImageAttribute()
	{
		return Upload::getFile('category', $this->id);
	}

	public function getUrlAttribute()
	{	
		$aliases = $this->ancestorsAndSelf()
			->pluck('alias')
			->toArray();

		if(count($aliases) == 1) {
			$url = route('frontend.product.index', $aliases[0]);
		} else {
			$url = route('frontend.product.index', $aliases);
		}
		return $url;
	}
    
}   
