<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Upload;

class Car extends Model
{
    protected $guarded = [];
	protected $appends = ['image'];

    public function products()
    {
		return $this->belongsToMany(Product::class, 'product_car');
    }
    
    public function years()
    {
		return $this->belongsToMany(Year::class, 'car_year');
    }

    public function manufacturers()
    {
        return $this->belongsToMany(Manufacturer::class, 'manufacturer_car');
    }

	public function getImageAttribute()
	{
		return Upload::getFile('car', $this->id);
	}
}
