<?php

namespace App\Models;
use Upload;

use Illuminate\Database\Eloquent\Model;

class Banner extends Model
{
    protected $guarded = [];
	protected $appends = ['image_ru', 'image_uz'];

	public function getImageRuAttribute()
	{
		return Upload::getFile('banner_ru', $this->id);
	}

	public function getImageUzAttribute()
	{
		return Upload::getFile('banner_uz', $this->id);
	}

	public function getUrlFormatAttribute()
	{
		return $this->{'url_'.app()->getLocale()};
	}

	public function getImageFormatAttribute()
	{
		if (Upload::hasFile('banner_'.app()->getLocale(), $this->id)) {
			return Upload::getFile('banner_'.app()->getLocale(), $this->id);
		}
		return asset('assets/images/baner.jpg');
	}
}
