<?php

namespace App\Library;

use App\Models\User;
use App\Models\SmsCode;

class PhoneVerification
{

    public static function storeCode($user, $code, $message)
    {
        $sms_code = SmsCode::latest()->where('user_id', $user->id)->first();

        if (isset($sms_code) && !$sms_code->expires_at->isPast()) {
            return $sms_code;
        }

        // $code = rand(11111, 99999);
        $sms_code = SmsCode::create([
            'user_id' => $user->id,
            'code' => $code,
            'expires_at' => now()->addMinutes(2)
        ]);
		if (config('app.env') == 'production') {
        	self::sendSms($user->phone, $message);
		}
        return $sms_code;
    }

    public static function sendSms($phone, $message)
    {
        $client = new \GuzzleHttp\Client();
        $endpoint = 'https://send.smsxabar.uz/broker-api/send';
		$user = User::where('phone', $phone)->first();
        $body = [
            'messages' => [
                [
                    'recipient' => $phone,
                    'message-id' => 'drv'.str_pad($user->id ?? rand(1,10000), 8, '0', STR_PAD_LEFT),
                    'sms' => [
                        'originator' => 'DRIVERS',
                        'content' => [
                            'text' => $message,
                        ],
                    ],
                ],
            ],
        ];
		
        $response = $client->request('POST', $endpoint, [
            'headers' => [
                'Content-type' => 'application/json',
                'Accept' => 'application/json',
            ],
            'auth' => [
                config('services.sms.login'),
                config('services.sms.password'),
            ],
            'body' => json_encode($body),
        ]);

        $statusCode = $response->getStatusCode();
        $content = $response->getBody();
    }
}