<?php
namespace App\Library\Payments;

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;
use Schema;

class BaseDBMigration extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
    	Schema::create(config('payments.table_prefix').'payments', function (Blueprint $table)
		{
	    	$table->increments('id');
			$table->integer('account_id')->unsigned();
			$table->integer('amount')->unsigned();
			$table->integer('amount_tiin')->unsigned();
			$table->string('system_transaction_id', 30);
			$table->enum('system',array_keys(config('payments.systems',[])));
			$table->enum('state', ['pending','commited','canceled','canceled_after_commit'])->default('pending');
			$table->text('parameters');
			$table->timestamps();
			$table->index('account_id');
			$table->index(['system','system_transaction_id']);
		});


		Schema::create(config('payments.table_prefix').'payments_log', function ( $table)
		{
			$table->increments('id');
			$table->enum('system',array_keys(config('payments.systems',[])));
			$table->text('request');
			$table->text('response');
			$table->timestamp('created_at');
		});
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
    	Schema::drop(config('payments.table_prefix').'payments');
    	Schema::drop(config('payments.table_prefix').'payments_log');
    }
}
