<?php

namespace App\Library;

class Helper
{
	/**
	 * Создатель alias 
	 * 
	 * @param  Object $model
	 * @param  string $value
	 * 
	 * @return string
	 */
    public static function alias($model, $value)
    {
        $slug = str_slug($value);
        $slugCount = count($model->whereRaw("alias REGEXP '^{$slug}(-[0-9]+)?$' and id != '{$model->id}'")->get());

        return ($slugCount > 0) ? "{$slug}-{$slugCount}" : $slug;
    }

     /**
     * Presenting a hierarchy
     * 
     * @param  Object $node
     * @param  string $name
     * 
     * @return string
     */
    public static function renderNode($node, $name = '', $ids_to_check = [], $category_id = 0)
    {
		$html = '<ul class="nested-list">';
		$checkbox = '<label class="checkbox-second checkbox-second--textless">
			<input type="checkbox" name="'.$name.'[]" value="' . $node->id . '"'. (in_array($node->id, $ids_to_check) ? ' checked="checked"' : '') .'>
			<span></span>
		</label> ' . $node->name;

		$radio = '<label class="radio-second radio-second--textless nested-list__radio"><input type="radio" name="category_id" value="' . $node->id . '"'. ($node->id == $category_id ? ' checked="checked"' : '') .'><span></span></label>';

		if ($node->isLeaf()) {
			$html .= '<li class="nested-list__item">' . $checkbox. ' '.$radio.'</li>';
		} else {
			$html .= '<li class="nested-list__item"><a href="#" class="nested-list__link js-nested-list-item"> ' . $checkbox . ' <i class="fa fa-angle-right nested-list__caret"></i> '.$radio.'</a>';
			$html .= '<ul class="nested-list">';

			foreach ($node->children as $child) {
				$html .= self::renderNode($child, $name, $ids_to_check, $category_id);
			}

			$html .= '</ul>';
			$html .= '</li>';
		}

		$html .= '</ul>';

		return $html;
	}

	public static function renderBreadcrumbs($items = [])
	{
		$breadcrumbs = [
    		'last_key' => count($items)-1,
    		'home' => [
				'name' => __('main.home'),
				'url' => route('home')
    		]
	    ];

    	$html = '<ul class="breadcrumb">';
    	$html .= '<li class="breadcrumb__item"><a href="'.$breadcrumbs['home']['url'].'">'.$breadcrumbs['home']['name'].'</a></li>';
        foreach ($items as $key => $item) {
            if ($breadcrumbs['last_key'] == $key) {
                $html .= '<li class="breadcrumb__item active">'.$item['name'].'</li>';
            } else {
                $html .= '<li class="breadcrumb__item"><a href="'.$item['url'].'">'.$item['name'].'</a></li>';
            }
        }

        $html .= '</ul>';
    	return $html;
	}

	/**
	 * Translit UZ-RU RU-UZ
	 * 
	 * @param  string $text
	 * @param  string $lang
	 * @return string
	 */
	public static function translit($text, $lang = 'uz') {

        $rus = array('Ю', 'Я', 'Ч', 'Ш', 'Щ', 'А', 'Б', 'В', 'Г', 'Д', 'Е', 'Ё', 'Ж', 'З', 'И', 'Й', 'К', 'Л', 'М', 'Н', 'О', 'П', 'Р', 'С', 'Т', 'У', 'Ф', 'Х', 'Ц', 'Ъ', 'Ы', 'Ь', 'Э', 'ч', 'ш', 'щ', 'ю', 'я', 'а', 'б', 'в', 'г', 'д', 'е', 'ё', 'ж', 'з', 'и', 'й', 'к', 'л', 'м', 'н', 'о', 'п', 'р', 'с', 'т', 'у', 'ф', 'х', 'ц', 'ъ', 'ы', 'ь', 'э', 'Ҳ', 'ҳ', 'Қ', 'қ', 'Ғ', 'ғ', 'Ў', 'ў');

        $lat = array('Yu', 'Ya', 'Ch', 'Sh', 'Sch', 'A', 'B', 'V', 'G', 'D', 'E', 'Yo', 'J', 'Z', 'I', 'Y', 'K', 'L', 'M', 'N', 'O', 'P', 'R', 'S', 'T', 'U', 'F', 'X', 'S', '’', 'I', '', 'E', 'ch', 'sh', 'sch', 'yu', 'ya', 'a', 'b', 'v', 'g', 'd', 'e', 'yo', 'j', 'z', 'i', 'y', 'k', 'l', 'm', 'n', 'o', 'p', 'r', 's', 't', 'u', 'f', 'x', 's', '’', 'i', '', 'e', 'H', 'h', 'Q', 'q', 'G’', 'g’', 'O’', 'o’');

        if($lang == 'uz') {
            return str_replace($rus, $lat, $text);
        }
        else if($lang == 'ru') {
            return str_replace($lat, $rus, $text);   
        }

        return $text;
    }
}