<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class OrderResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        return [
			'id' => $this->id,
			'created_at_format' => $this->created_at_format,
			'total_cost_format' => $this->total_cost_format,
			'products' => OrderProductResource::collection($this->products),
			'delivery_type_format' => $this->delivery_type_format,
			'status_format' => $this->status_format,
			'payment_type_format' => $this->payment_type_format
		];
    }
}
