<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class OrderProductResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        return [
			'id' => $this->id,
			'category' => $this?->product?->category?->name,
			'product' => ($this?->product?->name ?? $this?->product?->name_ru) ?? 'Удалено',
			'total_cost_format' => $this->total_cost_format,
			'quantity' => $this->quantity,
			'url' => $this?->product?->url,
			'image' => $this?->image
		];
    }
}
