<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;
use Upload;
class Favorite extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'id'      => $this->id, 
            'product' => $this->product->{'name_'.app()->getLocale()},
            'image'   => Upload::hasFile('product', $this->product->id) ? Upload::getThumbFile('product', $this->product->id, '130x110') : '',
            'alias'   => route('frontend.product.show').'/'.$this->product->alias,
            'price'   => $this->product->price_format,
            'count_comment' => $this->product->count_comment,
            'rating'        => $this->product->rating   
        ];
    }
}
