<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class Address extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'id'   => $this->id,
            'region' => $this->region ? $this->region->name : 'Удалено',
            'district' => $this->district ? $this->district->name : 'Удалено',
            'street' => $this->street,
            'house_number' => $this->house_number,
            'floor' => !is_null($this->floor) ? $this->floor : 'Не указано',
            'entrance' => !is_null($this->entrance) ? $this->entrance : 'Не указано',
            'apartment' => !is_null($this->apartment) ? $this->apartment : 'Не указано',
            'main_address' => $this->main_address            
        ];
    }
}
