<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Library\PhoneVerification;
use Illuminate\Validation\Rule;
use App\Models\SmsCode;

class VerificationController extends Controller
{
    public function index()
    {
        $user = request()->user();                

        $sms_code = SmsCode::latest()->where('user_id', $user->id)->first();

        $time_left = $this->timeLeft($sms_code);
        return view('frontend.user.verify', [
            'sms_code' => $sms_code,
            'time_left' => $time_left
        ]);
    }

    /**
     * Active user until sms code expires
     *
     * @return void
     */
    public function verify()
    {
        $user = request()->user();
        $data = request()->validate([
            'code'      => [
                'required',
                Rule::exists('sms_codes')->where(function ($query) use ($user) {
                    $query->where('user_id', $user->id);
                    $query->where('code', request()->code);
                    $query->where('expires_at', '>=', now());
                    $query->orderBy('id', 'desc');
                }),
            ],
        ]);
        
        $user->phone_verified_at = now();
        $user->save();

        return redirect()->route('home')
                         ->with('success', 'Вы успешно зарегистрировались');
    }

    public function sendCode()
    {
        $user = request()->user();
		$code = rand(111111, 999999);
		$message = 'Ваш код для подтверждения: '.$code.' shop.driversvillage.uz';
        $sms_code = PhoneVerification::storeCode($user, $code, $message);
        return response()->json([
            'time_left' => $this->timeLeft($sms_code),
            'success' => true
        ]);
    }

    public function timeLeft($sms_code)
    {
        if ($sms_code) {
            $time_left = strtotime($sms_code->expires_at) - strtotime(now());

            if ($time_left < 1) {
                return 0;
            }

            return $time_left;

        } else {
            return 0;
        }

    }
}
