<?php
namespace App\Http\Controllers\Payment;

use App\Models\Order;
use App\Mail\PaidMail;
use App\Mail\CancelMail;
use App\Mail\PaidClientMail;
use Illuminate\Support\Facades\Mail;
use App\Library\Payments\BaseTransactionModel as Transaction;
use DB;

trait PaymentsTrait
{
	public function onTransactionCommited(Transaction $transaction)
	{
		$app = Order::find($transaction->account_id);
		if ($app) {

            DB::transaction(function() use ($app, $transaction) {
                $app->status = 'paid';
                $app->payment_id = $transaction->id;
                $app->save();

                $history = $app->histories()->create([
                    'status' => 'paid',
                    'user_id' => 0
                ]);
            });
            

            try {
                // Mail::to('info@driversvillage.uz')
                //     ->send(new PaidMail($app));
                // Mail::to($app->email)
                //     ->send(new PaidClientMail($app));
            } catch (\Exception $e) {

            }
		}
    }
    
	public function onTransactionCanceled(Transaction $transaction)
	{
		$app = Order::find($transaction->account_id);
		if ($app) {
            DB::transaction(function() use ($app, $transaction) {
                $app->status = 'canceled';
                $app->payment_id = $transaction->id;
                $app->save();

                $history = $app->histories()->create([
                    'status' => 'canceled',
                    'user_id' => 0
                ]);
            });

            try {
                // Mail::to('info@driversvillage.uz')
                //     ->send(new CancelMail($app));
            } catch (\Exception $e) {

            }
		}
	}
}