<?php

namespace App\Http\Controllers\Payment;

use App\Models\OrderProduct;
use App\Library\Payments\Paycom\Controller as Paycom;


class PaycomController extends Paycom
{
	use PaymentsTrait;

	public function actionCheckPerformTransaction()
	{
		$items = OrderProduct::where('order_id', $this->getAccountId())->get();
		return $this->response([
			'allow' => true,
			'detail' => [
				'receipt_type' => 0, //тип фискального чека,
				'items' => $items->map(fn ($item) => [
					'title' => $item->product->name, //наименование товара или услуги
					'price' => $item->price*100, //цена за единицу товара или услуги, сумма указана в тийинах
					'count' => $item->quantity, //кол-во товаров или услуг
					'code' => $item->product?->paymeSetting?->code, // код *ИКПУ обязательное поле
					'vat_percent' => config('payments.vat_percent'), //обязательное поле, процент уплачиваемого НДС для данного товара или услуги
					'package_code' => $item->product?->paymeSetting?->package_code //Код упаковки для конкретного товара или услуги, содержится на сайте в деталях найденного ИКПУ.
				])
					
			]
		]); 
	}
}