<?php

namespace App\Http\Controllers\Payment;

use App\Mail\PaidMail;
use App\Models\Subscriber;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Mail;

class ApelsinController extends Controller
{
    public function callbackRoute()
    {
        if (!in_array($this->getUserIP(), [
            '87.237.235.235', '185.183.243.64', '87.237.235.232', '127.0.0.1'
        ])) {
            abort(403);
        }

        $app = Subscriber::where('type', 'apelsin')
                        ->where('status', 'created')
                        ->where('id', request()->order_id)
                        ->first();
        
		if ($app) {
            $app->status = 'paid';
            $app->save();

            try {
                // Mail::to('info@driversvillage.uz')
                //     ->send(new PaidMail($app));
            } catch (\Exception $e) {

            }

            return response()->json([
                'status' => true
            ]);
		} else {
            return response()->json([
                'status' => false
            ]);
        }
    }

    public function getUserIP() 
    {
        // Get real visitor IP behind CloudFlare network
        if (isset($_SERVER["HTTP_CF_CONNECTING_IP"])) {
                $_SERVER['REMOTE_ADDR'] = $_SERVER["HTTP_CF_CONNECTING_IP"];
                $_SERVER['HTTP_CLIENT_IP'] = $_SERVER["HTTP_CF_CONNECTING_IP"];
        }
        $client  = @$_SERVER['HTTP_CLIENT_IP'];
        $forward = @$_SERVER['HTTP_X_FORWARDED_FOR'];
        $remote  = $_SERVER['REMOTE_ADDR'];

        if(filter_var($client, FILTER_VALIDATE_IP)) {
            $ip = $client;
        } elseif(filter_var($forward, FILTER_VALIDATE_IP)) {
            $ip = $forward;
        } else {
            $ip = $remote;
        }

        return $ip;
    }
}
