<?php

namespace App\Http\Controllers;

use Cart;
use App\Models\Help;
use App\Models\Page;
use App\Models\Banner;
use App\Models\Slider;
use App\Models\Product;
use App\Models\Feedback;
use App\Models\MainPage;
use App\Models\Manufacturer;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class PageController extends Controller
{
    public function index()
    {	
        $banner = Banner::where('status', 1)->get();
        $sliders = Slider::latest()->get();
        $manufacturers = Manufacturer::get();
        $main_pages = MainPage::where('status', 1)->get();
        $discounts = Product::quantity()->has('paymeSetting')->whereNotNull('discount')->get();
        $xits = Product::quantity()->limit(8)->get();
    	return view('frontend.page.index', compact('banner', 'sliders', 'manufacturers', 'main_pages', 'discounts', 'xits'));
    }

    public function help()
    {
        $helps = Help::get();

    	return view('frontend.page.help', compact('helps'));
    }

    public function contact()
    {
    	return view('frontend.page.contact');
    }

    public function postContact()
    {        
        $data = request()->validate([
            'name' => 'required|max:255',
            'phone' => 'required|max:20',
            'message' => 'max:500'
        ]);

        $data['phone'] = preg_replace('/[\+\-\(\)]/', '', $data['phone']);

        Feedback::create($data);
        session()->flash('success', 'Ваше сообщение успешно отправлено');
        return redirect()->back();
    }

    public function show($alias)
    {
        $page = Page::where('alias', $alias)->firstOrFail();
        return view('frontend.page.show', compact('page'));
    }
}
