<?php

namespace App\Http\Controllers;

use GuzzleHttp\Client as GClient;

use Cart;
use Upload;
use App\Rules\Phone;
use App\Models\Order;
use App\Models\Region;
use App\Models\Product;
use App\Models\Notification;
use App\Models\OrderHistory;
use App\Models\OrderProduct;
use Illuminate\Http\Request;
use Illuminate\Validation\Rule;
use Illuminate\Support\Facades\DB;

class CartController extends Controller
{
    public function add()
    {
        $id = request()->input('id');
        $product = Product::quantity()->has('paymeSetting')->findOrFail($id);
		$product_cart = Cart::get($id);
		
		if ($product_cart && $product_cart->quantity >= $product->quantity) {
			return response()->json([
				'status' => false,
				'message' =>  'Вы выбрали '.$product_cart->quantity.' товар(ов).'.' На складе больше не осталось'
			]);
		}
    	Cart::add([
		    'id' => $id,
		    'name' => $product->name,
		    'price' => $product->current_price,
		    'quantity'	=> 1,
		    'attributes' => array(
                'category' => $product->categories()->first()->name ?? '',
				'alias' => $product->alias,
				'image' => $product->image,
				'discount' => $product->discount,
				'original_price' => $product->price,
				'quantity' => $product->quantity,
				'link' => route('frontend.product.show', $product->alias),
            ),
            'associatedModel' => $product 
		]);

        $count = Cart::getContent()->count();	

        return response()->json([
			'status' => true,
			"message" => 'succuss',
            'product' =>  [
                'img'   =>  $product->image,
                'name'  =>  $product->name
            ],
            'count' =>  $count
		]);
    }

    public function cartList()
    {
        $count = Cart::getTotalQuantity();
		$cartCollection = Cart::getContent();
    	$content = $cartCollection->sort();
    	$cartTotal = Cart::getTotal();		
		return view('frontend.cart.index', compact('content','cartTotal','count'));
    }

    public function cartRemove()
    {
        $id = request()->input('id');
    	Cart::remove($id);
        $cartTotal = Cart::getTotal();	
        $count = Cart::getContent()->count();			
    	return response()->json([
			'status' => true,
			"message" => 'succuss',
            'cartTotal' =>  number_format($cartTotal, 0, ',', ' '),
            'count' =>  $count
		]);
    }

    public function cartChange()
    {
        $id = request()->input('id');
        $item = Cart::get($id);
        if ($item && request()->has('qty')) {
			Cart::update($id, array(
				'quantity' => array(
					'relative' => false,
					'value' => request()->input('qty')
				),
				'attributes' => array(
					'category' => $item->associatedModel->categories()->first()->name ?? '',
					'alias' => $item->associatedModel->alias,
					'image' => $item->associatedModel->image,
					'discount' => $item->associatedModel->discount,
					'quantity' => $item->associatedModel->quantity,
					'original_price' => $item->associatedModel->price,
					'link' => route('frontend.product.show', $item->associatedModel->alias),
				),
			));			
			$cartTotal = Cart::getTotal();
			$itemTotal =  $item->price * request()->input('qty');
			return response()->json([
				'status' => true,
				"message" => 'succuss',
				'disabled' => $item->quantity >= $item->associatedModel->quantity ? true : false,
				'cartTotal' =>  number_format($cartTotal, 0, ',', ' '),
				'itemTotal' =>  number_format($itemTotal, 0, ',', ' '),
			]); 
        }
    }

    public function checkout()
    {	
		if (Cart::isEmpty()) {
			return redirect()->route('home');
		}			
		$cartTotal = Cart::getTotal();		
		$region = Region::find(1);
		$cities = Region::where('parent_id',$region->id)->get();
    	return view('frontend.cart.checkout', compact('cartTotal', 'region', 'cities'));
    }

	public function postCheckout()
	{
		$user = request()->user();
		request()->merge([
            'phone_number' => preg_replace('/[\+\-\(\)\s]/', '', request()->phone_number),
            'additional_number' => preg_replace('/[\+\-\(\)\s]/', '', request()->additional_number),
        ]);		
		if (Cart::isEmpty()) {
			return redirect()->route('home');
		}
		
		$data = request()->validate([
			'last_name' => 'required|max:200',
			'first_name' => 'required|max:200',
			'phone_number' => !$user ? ['required', 'digits:12', new Phone] : 'nullable',
			'additional_number' => ['nullable', 'digits:12', new Phone],
			'delivery_type' => 'required|in:pickup,express',
			'region_id' => ['required', Rule::exists('regions', 'id')->where('parent_id', null)],
			'district_id' => [Rule::requiredIf(fn () => (request()->delivery_type == 'express')), Rule::when(request()->delivery_type == 'express', Rule::exists('regions', 'id')->where('parent_id', '!=', null))],
			'address' => [Rule::requiredIf(fn () => (request()->delivery_type == 'express')), 'max:200'],
			// 'payment_type' => 'required|in:payme,click,uzum'.(request()->delivery_type == 'pickup' ? ',cash,terminal' : ''),
			'comment' => 'nullable|max:500'
		],[],[
			'last_name' => 'Фамилия',
			'first_name' => 'Имя',
			'phone_number' => 'Номер телефона',
			'additional_number' => 'Дополнительный номер телефона',
			'delivery_type' => 'Тип доставки',
			'payment_type' => 'Способ оплаты',
			'region_id' => 'Город',
			'district_id' => 'Район',
			'address' => 'Адрес',
			'comment' => 'Комментарий'
		]);

		$data['payment_type'] = 'cash';
		
		DB::beginTransaction();
		try {
			if ($user) {
				$data['user_id'] = $user->id;
				$data['phone_number'] = $user->phone;				
			}
			if ($data['delivery_type'] == 'pickup') {
				$data['region_id'] = null;
				$data['district_id'] = null;
				$data['address'] = null;
			}
			$cartCollection = Cart::getContent();
			$content = $cartCollection->sort();
			$data['total_cost'] = Cart::getTotal();
			$data['total_amount'] = Cart::getTotalQuantity();
			$order = Order::create($data);
			if ($order) {
				foreach ($content as $product) {					
					$order_product = new OrderProduct;
					$order_product->order_id = $order->id;
					$order_product->product_id = $product->id;
					$order_product->quantity = $product->quantity;
					$order_product->original_price = $product->attributes['original_price'];
					$order_product->discount = $product->attributes['discount'] ?? 0;
					$order_product->price = $product->price;
					$order_product->total_cost = $product->price*$product->quantity;
					$order_product->save();
					$product_model = Product::find($product->id);
					$product_model->update([
						'quantity' => $product_model->quantity - $order_product->quantity
					]);
				}
			}			
			Notification::create([
				'user_id' => $user->id ?? null,
				'phone' => $data['phone_number'],
				'text_ru' => 'Ваш заказ №'.$order->id.' успешно оформлен',
				'text_uz' => 'Sizning №'.$order->id.' raqamli buyurtmangiz muvaffaqqiyatli rasmiylashtirildi',				
			]);
			OrderHistory::create([
				'order_id' => $order->id,
				'user_id'  => $user->id ?? null,
				'status' => 'pending'
			]);
			Cart::clear();
			
			 $client = new GClient([
                "base_uri" => "https://api.telegram.org",
            ]);
            
            $zakaz = $order->id;
            $phone = $data['phone_number'];
            
            $bot_token = "6831059850:AAEocenPGmof7h2XTcEa84mD6OYcz2CbT90";
            $chat_id = "-1001995706670";
            $message = "<b><u>✅  Новый заказ</u></b>\n\n<b>💠 Заказ:</b> $zakaz \n<b>🤵‍♂️ Тел номер:</b> $phone \n";
            $response = $client->request("GET", "/bot$bot_token/sendMessage", [
                
                "query" => [
                    "chat_id" => $chat_id,
                    "text" => $message,
                    "parse_mode" => "html"
                ]
            ]);
        
			DB::commit();
			return response()->json([
				'message' => 'Ваш заказ успешно оформлен',
				'url' => $order->is_online_payment ? route('cart.complete', $order->id) : route('frontend.cabinet.index')
			]);
		} catch (\Exception $e) {
			DB::rollback();
			info($e->getMessage());
		} 				
	}

	public function complete(Order $order)
	{
		return view('frontend.cart.complete', compact('order'));
	}
}
