<?php

namespace App\Http\Controllers;

use App\Models\Blog;    
use Illuminate\Http\Request;

class BlogController extends Controller
{

    public function index()
    {
        $blogs = Blog::latest()->paginate(9);
        return view('frontend.news.index', compact('blogs'));
    }

    public function show($alias)
    {
        $blog = Blog::where('alias', $alias)->firstOrFail();
        return view('frontend.news.show', compact('blog'));
    }
}
