<?php

namespace App\Http\Controllers\Backend;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Year;

class YearController extends Controller
{
    public function index()
    {    	
    	return view('backend.year.index');
    }

    /**
	 * Get data for Datatable
	 * @return json
	 */
    public function data()
    {
    	$year = Year::query();
        return datatables()->of($year)
                ->addColumn('exist', function($item) {
                    return $item->cars()->exists() ? 1 : 0;                    
                })->toJson();
    }

	/**
	 * Create and edit form
     * 
	 * @param  Request $request
	 * @return json
	 */
	public function form()
	{
        $id = request()->input('id');
        
		$data = request()->validate([
            'year'     => 'required|digits:4'
        ]);	    

    	if ($id != NULL) {
    		$year = Year::find(request()->input('id'));
    		if($year) {
    			$year->update($data);
            }                  
    	} else {    		
            $year = Year::create($data);
        }        
        
    	return response()->json(['status' => 'success']);
    }
    
    /**
     * Delete car
     * @param  Request $request
     * @return json           
     */
    public function delete()
    {
		if(request()->has('id')) {
           $year = Year::find(request()->input('id'));           
           $year->delete();       

			$response = [
				'status' => 'success',
				'message' => trans('alert.success.delete')
			];
		} else {
			$response = [
				'status' => 'error',
				'message' => 'Пожалуйста попробуйте снова'
			];
		}
		
		return response()->json($response);
	}
}
