<?php

namespace App\Http\Controllers\Backend;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\User;
use App\Models\Role;
use DB;

class UserController extends Controller
{
    public function index()
    {
        $roles = Role::orderBy('id', 'asc')->get();
        return view('backend.user.index', ['roles' => $roles]);
    }

    public function data()
    {
        $data = User::whereHas('roles', function($query) {
			$query->where('code', '!=', 'superadmin');
		});
        return datatables()->of($data)
                ->editColumn('name', function($item) {
                    return $item->full_name;
                })->addColumn('role_name', function($user) {
                    $roles = $user->roles()->implode('name_ru', ',');
					return '<span class="badge badge-primary">'.$roles.'</span>';
                })->addColumn('roles', function($item) {                    
                    return $item->roles->implode('id',',');                
                })->filterColumn('name', function ($query, $keyword) {
                    $query->whereRaw("CONCAT(users.first_name, ' ', users.last_name) like ?", ["%$keyword%"]);
                })->rawColumns(['role_name'])->toJson();
    }   

    public function form()
    {                   
        $id = request()->input('id');

        $data = request()->validate([
            'name'     => 'required|max:100',
            'phone'    => ($id ? 'required|unique:users,phone,'.$id : 'required|unique:users,phone'),
            'password' => 'same:password_confirmation',
            'roles'    => 'array|min:1'
        ]);
        
        if (!empty($data['password'])) { 
            $data['password'] = bcrypt($data['password']);
        } else {
            $data = array_except($data,array('password'));    
        }

        $user = User::find($id);
        unset($data['rules']);     
        if ($user) {
            $user->update($data);
            DB::table('role_user')->where('user_id', $id)->delete();
            $message = trans('alert.success.update');
        } else {
            $user = User::create($data);
            $message = trans('alert.success.insert');
        }

        $user->roles()->sync(request()->input('roles'));

        return response()->json(['status' => 'success', 'message' => $message]);
    }

    public function delete()
    {
        if (request()->has('id')) {
            $item = User::find(request()->input('id'));           
            $item->delete();            
            DB::table('role_user')->where('user_id', $item->id)->delete();
            $response = [
                'status' => 'success',
                'message' => trans('alert.success.delete')
            ];                                   
        } else {
            $response = [
                'status' => 'error',
                'message' => 'Пожалуйста попробуйте снова'
            ];
        }
      
        return response()->json($response);
    }
}
