<?php

namespace App\Http\Controllers\Backend;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Slider;
use Upload;

class SliderController extends Controller
{
    public function index()
    {    	
    	return view('backend.slider.index');
    }

    /**
	 * Get data for Datatable
	 * @return json
	 */
    public function data()
    {
    	$slider = Slider::query();
        return datatables()->of($slider)->toJson();
    }

	/**
	 * Create and edit form
     * 
	 * @param  Request $request
	 * @return json
	 */
	public function form()
	{
        $id = request()->input('id');
        
		$data = request()->validate([
            'url_ru'     => 'nullable|url',
            'url_uz'     => 'nullable|url'            
        ]);

    	if ($id != NULL) {
    		$slider = Slider::find(request()->input('id'));
    		if($slider) {
    			$slider->update($data);
            }                  
    	} else {
            $slider = Slider::create($data);
        }

        if (request()->hasFile('image_ru')) {
            Upload::saveFile('slider_ru', $slider->id, request()->file('image_ru'), [
                'name' => $slider->id.'_sld_ru'
            ]);
        }

        if (request()->hasFile('image_uz')) {
            Upload::saveFile('slider_uz', $slider->id, request()->file('image_uz'), [
                'name' => $slider->id.'_sld_uz'
            ]);
        }
        
    	return response()->json(['status' => 'success']);
    }
    
    /**
     * Delete car
     * @param  Request $request
     * @return json           
     */
    public function delete()
    {
		if (request()->has('id')) {
            $slider = Slider::find(request()->input('id'));            
            $slider->delete();
            Upload::removeFile('slider_ru', $slider->id);
            Upload::removeFile('slider_uz', $slider->id);

			$response = [
				'status' => 'success',
				'message' => trans('alert.success.delete')
			];
		} else {
			$response = [
				'status' => 'error',
				'message' => 'Пожалуйста попробуйте снова'
			];
		}
		
		return response()->json($response);
	}
}
