<?php

namespace App\Http\Controllers\Backend;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Library\Helper;

use App\Models\Setting;
use Upload;

class SettingController extends Controller
{
    public function index()
    {
        return view('backend.setting.index');
    }

    public function data()
   	{
   		$query = Setting::query();
   		return datatables()->of($query)->toJson();
   	}

   	public function getForm($id = null)
   	{
   		$setting = Setting::find($id);
        if (!$setting) $setting = [];

        return view('backend.setting.form', [
            'setting' => $setting,
            'id' => $id
        ]);
   	}

   	public function postForm($id = null) 
   	{
   		$data = request()->validate([
   			'value_ru'  => 'nullable|max:255',
            'value_uz'  => 'nullable|max:255',
            'atribute' => 'nullable|max:255',
            'value_one' => 'nullable|max:255' 		
   		]);

   		if ($id == null) {
   			$setting = Setting::create($data);
   			session()->flash('success', trans('alert.success.insert'));
   		} else {
   			$setting = Setting::find($id);            
            $setting->update($data);
            session()->flash('success', trans('alert.success.update'));            
        }  

   		return redirect()->route('backend.setting.index');
   	}

   	public function delete()
   	{
        return response()->json(['status' => 's']);
    }

    public function status()
    {
        return response()->json(['status' => 's']);
    }
}
