<?php

namespace App\Http\Controllers\Backend;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Region;

class RegionController extends Controller
{
    public function index()
    { 
    	$breadcrumbs = [
    		'last_key' => 0,
    		'list' => [
	    		'' => 'Главная'
	    	]
	    ];

    	if(request()->has('parent_id')) {

    		$regions = Region::where('id', request()->input('parent_id'))
    			->first()
    			->getAncestorsAndSelf()
    			->pluck('name_ru', 'id')
    			->toArray();

    		$breadcrumbs['list'] = $breadcrumbs['list'] + $regions;

    		end($breadcrumbs['list']);
    		$breadcrumbs['last_key'] = key($breadcrumbs['list']);
    	}        

    	return view('backend.region.index', [
            'breadcrumbs' => $breadcrumbs
        ]);
    }

    /**
	 * Get data for Datatable
	 * @return json
	 */
    public function data()
    {
    	$region = Region::query();
    	if(request()->has('parent_id')) {
    		$region = $region->where('parent_id', request()->input('parent_id'));
    	} else {
    		$region = $region->where('parent_id', null);
    	}
    	
    	return datatables()->of($region)->make(true);
    }

	/**
	 * Create and edit form
     * 
	 * @param  Request $request
	 * @return json
	 */
	public function form()
	{
        $id = request()->input('id');
        
		$data = request()->only(
			'name_ru',
			'name_uz'            
		);        

		$rules = [
			'name_ru' 		=> 'required|min:2|max:255',
			'name_uz' 		=> 'required|min:2|max:255'                        
		];

		$validator = validator()->make($data, $rules);

	    if ($validator->fails()) {
	     	return response()->json([
	     		'status' => 'error',
	     		'errors' => $validator->messages()
	     	]);
	    }

    	if ($id != NULL) {
    		$region = Region::find(request()->input('id'));
    		if($region) {
    			$region->update($data);
            }
            
    	} else {
    		$data['alias'] = \App\Library\Helper::alias(new Region, $data['name_ru']);
    		if(request()->input('parent_id') != NULL) {
    			$root = Region::find(request()->input('parent_id'));
    			$region = $root->children()->create($data);
    		} else {
                $region = Region::create($data);                
    		}
        }
        
    	return response()->json(['status' => 'success']);
    }
    
    /**
     * Delete region
     * @param  Request $request
     * @return json           
     */
    public function delete()
    {
		if(request()->has('id')) {
			$region = Region::find(request()->input('id'));
			$region->delete();

			$response = [
				'status' => 'success',
				'message' => trans('alert.success.delete')
			];
		} else {
			$response = [
				'status' => 'error',
				'message' => 'Пожалуйста попробуйте снова'
			];
		}
		
		return response()->json($response);
	}
}
