<?php

namespace App\Http\Controllers\Backend;

use App\Models\PaymeSetting;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class PaymeSettingController extends Controller
{
    public function index()
    {    	        
     	return view('backend.payme-setting.index');
    }

    /**
	 * Get data for Datatable
	 * @return json
	 */
    public function data()
    {
    	$data = PaymeSetting::withCount('products');
    	return datatables()->of($data)->toJson();            
    }

	/**
	 * Create and edit form
     * 
	 * @param  Request $request
	 * @return json
	 */
	public function form()
	{
        $id = request()->input('id');
        
		$data = request()->validate([
			'name'    		  => 'required|max:255',
            'code'     		  => 'required|numeric',
            'package_code'    => 'required|numeric'
        ]);
                
    	if ($id != NULL) {
    		$item = PaymeSetting::find(request()->input('id'));
    		if($item) {
                $item->update($data);                
            }                  
    	} else {
            $item = PaymeSetting::create($data);
        }        
        
    	return response()->json(['status' => 'success']);
    }
    
    /**
     * Delete help
     * @param  Request $request
     * @return json           
     */
    public function delete()
    {
		if(request()->has('id')) {
            $item = PaymeSetting::find(request()->input('id'));
			if ($item->products()->count() == 0) {
				$item->delete();
			}            

			$response = [
				'status' => 'success',
				'message' => trans('alert.success.delete')
			];
		} else {
			$response = [
				'status' => 'error',
				'message' => 'Пожалуйста попробуйте снова'
			];
		}
		
		return response()->json($response);
	}
}
