<?php

namespace App\Http\Controllers\Backend;

use Upload;
use Analytics;
use App\Models\Car;
use App\Models\Page;
use App\Models\User;
use App\Models\Order;
use App\Library\Helper;
use App\Models\Comment;
use App\Models\Product;
use App\Models\NewProduct;
use App\Models\Manufacturer;
use Illuminate\Http\Request;
use Spatie\Analytics\Period;
use App\Http\Controllers\Controller;
use Str;

class PageController extends Controller
{
    public function dashboard()
    {
        $count['product'] = Product::count();
        $count['user'] = User::count();
        $count['comment'] = Comment::count();
        $count['car'] = Car::count();
        $count['manufacturer'] = Manufacturer::count();
        
        // $top_browsers = Analytics::fetchTopBrowsers(Period::days(7), 8);

        // $browsers = [
        //     'browser' => [],
        //     'sessions' => []
        // ];

        // foreach($top_browsers as $browser) {
        //     $browsers['browser'][] = $browser['browser'];
        //     $browsers['sessions'][] = $browser['sessions'];
        // }

        // $browsers['browser'] = implode(',', $browsers['browser']);
        // $browsers['sessions'] = implode(',', $browsers['sessions']);

        // $total_visitors_and_page_views = Analytics::fetchTotalVisitorsAndPageViews(Period::days(7));
        // $total_visitors = [
        //     'dates' => [],
        //     'visitors' => [],
        //     'pageViews' => []
        // ];

        // foreach($total_visitors_and_page_views as $item) {
        //     $total_visitors['dates'][] = $item['date']->format('d M');
        //     $total_visitors['visitors'][] = $item['visitors'];
        //     $total_visitors['pageViews'][] = $item['pageViews'];
        // }

        // $total_visitors['dates'] = implode(',', $total_visitors['dates']);
        // $total_visitors['visitors'] = implode(',', $total_visitors['visitors']);
        // $total_visitors['pageViews'] = implode(',', $total_visitors['pageViews']);

        // $most_visited_pages = Analytics::fetchMostVisitedPages(Period::days(7), 10);
        // $top_referrers = Analytics::fetchTopReferrers(Period::days(7), 10);
		$order_query = Order::query();
		$today = $this->orderCost('today');
		$yesterday = $this->orderCost('yesterday');
		$week = $this->orderCost('week');
		$month = $this->orderCost('month');
		$orders = [
            'labels' => ['Сегодня','Вчера','Последный 7 дней','Последный 30 дней'],
            'data' => [$today,$yesterday,$week,$month]
        ];
		$orders['labels'] = implode(',', $orders['labels']);
        $orders['data'] = implode(',', $orders['data']);

		$statuses = __('cabinet.order.statuses');
		
		$order_statuses = [
			'labels' => implode(',',array_values($statuses)),
			'data' => []
		];
		foreach ($statuses as $status_key=>$status) {			
			$order_statuses['data'][] = $this->orderCountByStatus($status_key);	
		}
		$order_statuses['data'] = implode(',', $order_statuses['data']);
        return view('backend.page.dashboard', [
            'count' => $count,
			'orders' => $orders,
			'order_statuses' => $order_statuses
        ]);
    }

	public function orderCost($type)
	{
		$total_cost = match($type) {
			'today' => Order::whereDate('created_at',now()->format('Y-m-d'))->where('status', 'delivered')->sum('total_cost'),
			'yesterday' => Order::whereDate('created_at', now()->subDay(1)->format('Y-m-d'))->where('status', 'delivered')->sum('total_cost'),
			'week' => Order::whereDate('created_at', '>=', now()->subDays(7)->format('Y-m-d'))->where('status', 'delivered')->sum('total_cost'),
			'month' => Order::whereDate('created_at', '>=', now()->subDays(30)->format('Y-m-d'))->where('status', 'delivered')->sum('total_cost'),
			default => 0
		};
		return $total_cost;
	}
    
    public function orderCountByStatus($status)
	{
		return Order::where('status', $status)->count();
	}
	
	public function newproduct()
	{
	    foreach(NewProduct::where('status', 1)->paginate(500) as $newp){
	        $data['barcode']  				= $newp->barcode;
	        $data['name_ru']  				= $newp->name;
	        $data['name_uz']  				= $newp->name;
	        $data['short_description_ru']   = 'Купить запчасть ' . $newp->name . ' с доставкой в Узбекистане';
	        $data['short_description_uz']   = $newp->name . ' еҳтиёт қисмини харид қилинг. Тошкент ва Ўзбекистоннинг барча худудларига етказиб берамиз';
	        $data['description_ru']  		= '<p>Купите ' . $newp->name . ' по доступным ценам, мы бесплатно доставим Вам по городу Ташкенту или в любой регион Узбекистана по доступным ценам.</p> <p>Simma Auto Star отличается доступными ценами и всеми способами оплаты. Подпишитесь на наши страницы в социальных сетях, чтобы быть в курсе наших акций и скидок.</p>';
	        $data['description_uz']  		= '<p>Сиз ' . $newp->name . ' ни улгурчи нархларда харид қилинг, Тошкент шахри ичида бепул ёки Узбекистоннинг исталган вилоятига сизга кулай нархларда етказиб берамиз.</p> <p>Simma Auto Star хамёнбоб нархлар ва барча тўлов усуллари мужассамлиги билан ажралиб туради. Акция ва чегирмаларимиздан хабардор бўлишингиз учун бизнинг ижтимоий сахифаларимизга аъзо бўлинг.</p>';
	        $data['meta_title_ru'] 		    = 'Купить запчасть ' . $newp->name . ' с доставкой в Узбекистане';
	        $data['meta_title_uz'] 		    = $newp->name . ' еҳтиёт қисмини харид қилинг. Тошкент ва Ўзбекистоннинг барча худудларига етказиб берамиз';
	        $data['category_id']  		    = 1;
	        $data['manufacturer_id'] 		= 1;
	        $data['meta_description_ru'] 	= 'Оригинальных запчастей для спецтехники и экскаваторов Ташкент и по всему Узбекистану';
	        $data['meta_description_uz'] 	= 'Махсус техника ва экскаваторлар учун оригинал (Асл) еҳтиёт қисмлар Тошкент ва Ўзбекистоннинг барча вилоятлари бўйлаб';
	        $data['alias']  			    = Product::where('alias', Str::slug($newp->name))->count() ? Str::slug($newp->name) . Product::where('alias', Str::slug($newp->name))->count() : Str::slug($newp->name);
	        $data['quantity']               = 0;
	        $data['payme_setting_id']	    = 1;

	        $product = Product::create($data);
	        $product->categories()->sync(['1']);
            $product->cars()->sync(['1']);
            $product->manufacturers()->sync(['1']);
            
            $newp->update(['status' => 2]);
	    }
	    
		dd('success');
	}

    public function index()
    {
        return view('backend.page.index');
    }

    public function data()
   	{
   		$query = Page::query();
   		return datatables()->of($query)->toJson();
   	}

   	public function getForm($id = null)
   	{
   		$page = Page::find($id);
        if (!$page) $page = [];

        return view('backend.page.form', [
            'page' => $page,
            'id' => $id
        ]);
   	}

   	public function postForm($id = null) 
   	{        
   		$data = request()->validate([
   			'title_ru'  => 'required|max:255',
            'title_uz'  => 'nullable|max:255',                        
            'text_ru'  	=> 'required',
            'text_uz'  	=> 'nullable',    		
   		]);

   		if ($id == null) {
   			$data['alias'] = Helper::alias(new Page, $data['title_ru']);
   			$page = Page::create($data);
   			session()->flash('success', trans('alert.success.insert'));
   		} else {
   			$page = Page::find($id);            
            $page->update($data);
            session()->flash('success', trans('alert.success.update'));            
        }       

        if (request()->hasFile('image')) {
            Upload::saveFile('page', $page->id, request()->file('image'), ['name' => $page->alias.'-'.$page->id]);
        }
		
   		return redirect()->route('backend.page.index');
   	}

   	public function delete()
   	{
   		if (request()->has('id')) {
            $item = Page::find(request()->input('id'));
            Upload::removeFile('page', $item->id);            
   			$item->delete();

   			$response = [
                'status' => 'success',
                'message' => trans('alert.success.delete')
            ]; 
   		} else {
   			$response = [
                'status' => 'error',
                'message' => 'Пожалуйста попробуйте снова'
            ];
   		}

   		return response()->json($response);
    }

    public function filemanager()
    {
        return view('backend.filemanager.index');
    }
}
