<?php

namespace App\Http\Controllers\Backend;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Manufacturer;
use App\Models\Car;
use Upload;
use DB;

class ManufacturerController extends Controller
{
    public function index()
    {    	
        $cars = Car::orderBy('id', 'desc')->get();
    	return view('backend.manufacturer.index', [
            'cars' => $cars
        ]);
    }

    /**
	 * Get data for Datatable
	 * @return json
	 */
    public function data()
    {
    	$manufacturer = Manufacturer::query();
    	return datatables()->of($manufacturer)
			->addColumn('exist', function($item) {
				return $item->product ? 1 : 0;                    
			})->addColumn('display_cars', function($item) {                    
				return $item->cars->map(function($car) {                                                
					return '<span class="badge badge-primary">'.$car->name.'</span>';
				})->implode(' ');                
			})->addColumn('cars', function($item) {                    
				return $item->cars->implode('id',',');                
			})->rawColumns(['display_cars'])->toJson();        
    }

	/**
	 * Create and edit form
     * 
	 * @param  Request $request
	 * @return json
	 */
	public function form()
	{
        $id = request()->input('id');        
		$data = request()->validate([
            'name'     => 'required|max:100',
            'cars'     => 'nullable|array|min:1'
        ]);	    

        unset($data['cars']);
    	if ($id != NULL) {
    		$manufacturer = Manufacturer::find(request()->input('id'));
    		if ($manufacturer) {
				$data['alias'] = \App\Library\Helper::alias(new Manufacturer, $data['name']);  
    			$manufacturer->update($data);
            }
            DB::table('manufacturer_car')->where('manufacturer_id', $manufacturer->id)->delete();
    	} else {
    		$data['alias'] = \App\Library\Helper::alias(new Manufacturer, $data['name']);    		
            $manufacturer = Manufacturer::create($data);
        }

        if (request()->hasFile('image')) {
            Upload::saveFile('manufacturer', $manufacturer->id, request()->file('image'), ['name' => $manufacturer->name]);
        }
        if(request()->input('cars')){
            $cars = Car::whereIn('id', request()->input('cars'))->get();
    		if (count($cars) > 0) {
    			$manufacturer->cars()->sync($cars->pluck('id'));
    		} 
        }
		       
        
    	return response()->json(['status' => 'success']);
    }
    
    /**
     * Delete car
     * @param  Request $request
     * @return json           
     */
    public function delete()
    {
		if(request()->has('id')) {
            $manufacturer = Manufacturer::find(request()->input('id'));
            Upload::removeFile('manufacturer', $manufacturer->id);
            DB::table('manufacturer_car')->where('manufacturer_id', $manufacturer->id)->delete();
            $manufacturer->delete();            

			$response = [
				'status' => 'success',
				'message' => trans('alert.success.delete')
			];
		} else {
			$response = [
				'status' => 'error',
				'message' => 'Пожалуйста попробуйте снова'
			];
		}
		
		return response()->json($response);
	}
}
