<?php

namespace App\Http\Controllers\Backend;

use App\Models\Category;
use App\Models\MainPage;
use Upload;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class MainPageController extends Controller
{
    public function index()
    {    	
        $categories = Category::whereNull('parent_id')->get();
    	return view('backend.main-page.index', [
            'categories' => $categories
        ]);
    }

    /**
	 * Get data for Datatable
	 * @return json
	 */
    public function data()
    {
    	$main_page = MainPage::with('category')->get();
    	return datatables()->of($main_page)
			->addColumn('category', function($item) {
				return $item->category->name_ru;
			})->toJson();
    }

	/**
	 * Create and edit form
     * 
	 * @param  Request $request
	 * @return json
	 */
	public function form()
	{
        $id = request()->input('id');
        
		$data = request()->validate([
            'category_id'    => 'required|exists:categories,id',
            'link_ru'        => 'nullable|url',
            'link_uz'        => 'nullable|url'
        ]);	    

      
    	if ($id != NULL) {
    		$main_page = MainPage::find(request()->input('id'));
    		if($main_page) {
    			$main_page->update($data);
            }
    	} else {
            $main_page = MainPage::create($data);
        }

        if (request()->hasFile('image_ru')) {
            Upload::saveFile('main_page_ru', $main_page->id, request()->file('image_ru'), ['name' => $main_page->id]);
        }
        if (request()->hasFile('image_uz')) {
            Upload::saveFile('main_page_uz', $main_page->id, request()->file('image_uz'), ['name' => $main_page->id]);
        }

        if (request()->hasFile('video_ru')) {
            Upload::saveFile('main_page_video_ru', $main_page->id, request()->file('video_ru'), ['name' => $main_page->id]);
        }
        if (request()->hasFile('video_uz')) {
            Upload::saveFile('main_page_video_uz', $main_page->id, request()->file('video_uz'), ['name' => $main_page->id]);
        }
        
    	return response()->json(['status' => 'success']);
    }
    
    /**
     * Delete car
     * @param  Request $request
     * @return json           
     */
    public function delete()
    {
		if(request()->has('id')) {
            $main_page = MainPage::find(request()->input('id'));
            Upload::removeFile('main_page_ru', $main_page->id);
            Upload::removeFile('main_page_uz', $main_page->id);
            $main_page->delete();            

			$response = [
				'status' => 'success',
				'message' => trans('alert.success.delete')
			];
		} else {
			$response = [
				'status' => 'error',
				'message' => 'Пожалуйста попробуйте снова'
			];
		}
		
		return response()->json($response);
	}

    public function status()
    {
        $id = request()->id;
        $banner = MainPage::find($id);
        if ($banner->status == 1) {
            $status = 0;
        } else {
            $status = 1;
        }
        $banner->update(['status' => $status]);
        return response()->json(['status' => $status]);
    }

    public function removeImg()
    {
        $id = request()->id;
        $lang = request()->lang;

        $item = MainPage::find($id);
        Upload::removeFile('main_page_'.$lang, $item->id);

        return response()->json(['status' => true]);
    }
}
