<?php

namespace App\Http\Controllers\Backend;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Help;

class HelpController extends Controller
{
    public function index()
    {    	        
     	return view('backend.help.index');
    }

    /**
	 * Get data for Datatable
	 * @return json
	 */
    public function data()
    {
    	$help = Help::query();
    	return datatables()->of($help)->toJson();            
    }

	/**
	 * Create and edit form
     * 
	 * @param  Request $request
	 * @return json
	 */
	public function form()
	{
        $id = request()->input('id');
        
		$data = request()->validate([
            'question_ru'     => 'required|max:255',
            'question_uz'    => 'max:255',
            'answer_ru'    => 'required',
            'answer_uz'    => 'nullable',
        ]);
                
    	if ($id != NULL) {
    		$help = Help::find(request()->input('id'));
    		if($help) {
                $help->update($data);                
            }                  
    	} else {
            $help = Help::create($data);
        }        
        
    	return response()->json(['status' => 'success']);
    }
    
    /**
     * Delete help
     * @param  Request $request
     * @return json           
     */
    public function delete()
    {
		if(request()->has('id')) {
            $help = Help::find(request()->input('id'));          
            $help->delete();            

			$response = [
				'status' => 'success',
				'message' => trans('alert.success.delete')
			];
		} else {
			$response = [
				'status' => 'error',
				'message' => 'Пожалуйста попробуйте снова'
			];
		}
		
		return response()->json($response);
	}
}
