<?php

namespace App\Http\Controllers\Backend;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Comment;

class CommentController extends Controller
{
    public function index()
    {
        return view('backend.comment.index');
    }

    public function data()
    {
        $comment = Comment::query();
        return datatables()->of($comment)
                ->addColumn('user', function($item) {                    
                    return $item->user->full_name ?? 'Пользователь удален';                    
                })->addColumn('product', function($item) {                    
                    return $item->product->name ?? 'Товар удален';;                    
                })
                ->toJson();
    }

    /**
     * Delete comment
     * @param  Request $request
     * @return json           
     */
    public function delete()
    {
		if (request()->has('id')) {
            $comment = Comment::find(request()->input('id'));            
            $comment->delete();            

			$response = [
				'status' => 'success',
				'message' => trans('alert.success.delete')
			];
		} else {
			$response = [
				'status' => 'error',
				'message' => 'Пожалуйста попробуйте снова'
			];
		}
		
		return response()->json($response);
    }
    
    public function status()
    {
        $id = request()->id;
        $comment = Comment::find($id);
        if ($comment->status == 1) {
            $status = 0;
        } else {
            $status = 1;
        }
        $comment->update(['status' => $status]);
        return response()->json(['status' => $status]);
    }
}
