<?php

namespace App\Http\Controllers\Backend;

use Upload;
use App\Library\Helper;
use App\Models\Category;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class CategoryController extends Controller
{
    public function index()
    {
    	$breadcrumbs = [
    		'last_key' => 0,
    		'list' => [
	    		'' => 'Главная'
	    	]
	    ];

    	if(request()->has('parent_id')) {

    		$categories = Category::where('id', request()->input('parent_id'))
    			->first()
    			->getAncestorsAndSelf()
    			->pluck('name_ru', 'id')
    			->toArray();

    		$breadcrumbs['list'] = $breadcrumbs['list'] + $categories;

    		end($breadcrumbs['list']);
    		$breadcrumbs['last_key'] = key($breadcrumbs['list']);
    	}        

    	return view('backend.category.index', [
            'breadcrumbs' => $breadcrumbs
        ]);
    }

    /**
	 * Get data for Datatable
	 * @return json
	 */
    public function data()
    {
    	$category = Category::query();
    	if(request()->has('parent_id')) {
    		$category = $category->where('parent_id', request()->input('parent_id'));
    	} else {
    		$category = $category->where('parent_id', null);
    	}
    	
        return datatables()->of($category)
                ->addColumn('exist', function($item) {
                    return $item->products()->exists() ? 1 : 0;                    
                })->toJson();
    }

	/**
	 * Create and edit form
     * 
	 * @param  Request $request
	 * @return json
	 */
	public function form()
	{
        $id = request()->input('id');
        
		$data = request()->only(
			'name_ru',
			'name_uz'            
		);        

		$rules = [
			'name_ru' 		=> 'required|min:2|max:255',
			'name_uz' 		=> 'required|min:2|max:255'                        
		];

		$validator = validator()->make($data, $rules);

	    if ($validator->fails()) {
	     	return response()->json([
	     		'status' => 'error',
	     		'errors' => $validator->messages()
	     	]);
	    }

    	if ($id != NULL) {
    		$category = Category::find(request()->input('id'));
    		if($category) {
    			$category->update($data);
            }
            
    	} else {
    		$data['alias'] = Helper::alias(new Category, $data['name_ru']);
    		if(request()->input('parent_id') != NULL) {
    			$root = Category::find(request()->input('parent_id'));
    			$category = $root->children()->create($data);
    		} else {
                $category = Category::create($data);                
    		}
        }

		if (request()->hasFile('image')) {
            Upload::saveFile('category', $category->id, request()->file('image'), [
                'name' => $category->id
            ]);
        }
        
    	return response()->json(['status' => 'success']);
    }
    
    /**
     * Delete category
     * @param  Request $request
     * @return json           
     */
    public function delete()
    {
		if(request()->has('id')) {
			$category = Category::find(request()->input('id'));
			if ($category->products()->count() == 0) {
				Upload::removeFile('category', $category->id);
				$category->delete();
			}			
			$response = [
				'status' => 'success',
				'message' => trans('alert.success.delete')
			];
		} else {
			$response = [
				'status' => 'error',
				'message' => 'Пожалуйста попробуйте снова'
			];
		}
		
		return response()->json($response);
	}
}
