<?php

namespace App\Http\Controllers\Backend;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Car;
use App\Models\Year;
use Upload;
use DB;

class CarController extends Controller
{
    public function index()
    {    	
        $years = Year::orderBy('id', 'asc')->get();
     	return view('backend.car.index', [
            'years' => $years
         ]);
    }

    /**
	 * Get data for Datatable
	 * @return json
	 */
    public function data()
    {
    	$car = Car::query();
    	return datatables()->of($car)
			->addColumn('exist', function($item) {
                return $item->products()->exists() ? 1 : 0;                    
            })->addColumn('display_years', function($item) {                    
                return $item->years->map(function($year) {                                                
                    return '<span class="badge badge-primary">'.$year->year.'</span>';
                })->implode(' ');                
            })->addColumn('years', function($item) {                    
                return $item->years->implode('id',',');                
            })->rawColumns(['display_years'])->toJson();            
    }

	/**
	 * Create and edit form
     * 
	 * @param  Request $request
	 * @return json
	 */
	public function form()
	{
        $id = request()->input('id');
        
		$data = request()->validate([
            'name'     => 'required|max:100',
            'years'    => 'nullable|array|min:1'
        ]);
        
        unset($data['years']);
    	if ($id != NULL) {
    		$car = Car::find(request()->input('id'));
    		if($car) {
                $data['alias'] = \App\Library\Helper::alias(new Car, $data['name']);  
                $car->update($data);
                DB::table('car_year')->where('car_id', $id)->delete();
            }                  
    	} else {
    		$data['alias'] = \App\Library\Helper::alias(new Car, $data['name']);    		
            $car = Car::create($data);
        }

        if (request()->hasFile('image')) {
            Upload::saveFile('car', $car->id, request()->file('image'), ['name' => $car->id]);
        }

        $car->years()->sync(request()->input('years'));
        
    	return response()->json(['status' => 'success']);
    }
    
    /**
     * Delete car
     * @param  Request $request
     * @return json           
     */
    public function delete()
    {
		if(request()->has('id')) {
            $car = Car::find(request()->input('id')); 
            DB::table('car_year')->where('car_id', $car->id)->delete();
            Upload::removeFile('car', $car->id);
            $car->delete();            

			$response = [
				'status' => 'success',
				'message' => trans('alert.success.delete')
			];
		} else {
			$response = [
				'status' => 'error',
				'message' => 'Пожалуйста попробуйте снова'
			];
		}
		
		return response()->json($response);
	}
}
