<?php

namespace App\Http\Controllers\Backend;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Library\Helper;

use App\Models\Blog;
use Upload;

class BlogController extends Controller
{
    public function index()
    {
        return view('backend.blog.index');
    }

    public function data()
   	{
   		$query = Blog::query();
   		return datatables()->of($query)->toJson();
   	}

   	public function getForm($id = null)
   	{
   		$blog = Blog::find($id);
        if (!$blog) $blog = [];

        return view('backend.blog.form', [
            'blog' => $blog,
            'id' => $id
        ]);
   	}

   	public function postForm($id = null) 
   	{
   		$data = request()->validate([
   			'title_ru'  => 'required|max:255',
            'title_uz'  => 'nullable|max:255',
            'short_text_ru' => 'nullable|max:255',
            'short_text_uz' => 'nullable|max:255',
            'description_ru'  	=> 'required',
            'description_uz'  	=> 'nullable', 
            'meta_keywords_ru'  => 'nullable',
            'meta_keywords_uz'  => 'nullable',
            'meta_description_ru' => 'nullable',
            'meta_description_uz' => 'nullable'   		
   		]);

   		if ($id == null) {
   			$data['alias'] = Helper::alias(new Blog, $data['title_ru']);
   			$blog = Blog::create($data);
   			session()->flash('success', trans('alert.success.insert'));
   		} else {
   			$blog = Blog::find($id);            
            $blog->update($data);
            session()->flash('success', trans('alert.success.update'));            
        }       

        if (request()->hasFile('main_image')) {
            Upload::saveFile('main_blog', $blog->id, request()->file('main_image'), ['name' => $blog->alias.'-'.$blog->id]);
        }

        if (request()->hasFile('inner_image')) {
            Upload::saveFile('inner_blog', $blog->id, request()->file('inner_image'), ['name' => $blog->alias.'-'.$blog->id]);
        }


   		return redirect()->route('backend.blog.index');
   	}

   	public function delete()
   	{
   		if (request()->has('id')) {
            $item = Blog::find(request()->input('id'));
            Upload::removeFile('main_blog', $item->id);
            Upload::removeFile('inner_blog', $item->id);
   			$item->delete();

   			$response = [
                'status' => 'success',
                'message' => trans('alert.success.delete')
            ]; 
   		} else {
   			$response = [
                'status' => 'error',
                'message' => 'Пожалуйста попробуйте снова'
            ];
   		}

   		return response()->json($response);
    }

    public function status()
    {
        $id = request()->id;
        $blog = Blog::find($id);
        if ($blog->is_active == 1) {
            $status = 0;
        } else {
            $status = 1;
        }
        $blog->update(['is_active' => $status]);
        return response()->json(['status' => $status]);
    }
}
