<?php

namespace App\Http\Controllers\Backend;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Banner;
use Upload;

class BannerController extends Controller
{
    public function index()
    {
    	return view('backend.banner.index');
    }

    /**
	 * Get data for Datatable
	 * @return json
	 */
    public function data()
    {
    	$banner = Banner::query();
        return datatables()->of($banner)->toJson();
    }

	/**
	 * Create and edit form
     * 
	 * @param  Request $request
	 * @return json
	 */
	public function form()
	{
        $id = request()->input('id');
        
		$data = request()->validate([
            'url_ru'     => 'nullable|url',
            'url_uz'     => 'nullable|url'            
        ]);

    	if ($id != NULL) {
    		$banner = Banner::find(request()->input('id'));
    		if($banner) {
    			$banner->update($data);
            }                  
    	} else {
            $banner = Banner::create($data);
        }

        if (request()->hasFile('image_ru')) {
            Upload::saveFile('banner_ru', $banner->id, request()->file('image_ru'), [
                'name' => $banner->id.'_banner_ru'
            ]);
        }

        if (request()->hasFile('image_uz')) {
            Upload::saveFile('banner_uz', $banner->id, request()->file('image_uz'), [
                'name' => $banner->id.'_banner_uz'
            ]);
        }
        
    	return response()->json(['status' => 'success']);
    }
    
    /**
     * Delete banner
     * @param  Request $request
     * @return json           
     */
    public function delete()
    {
		if (request()->has('id')) {
            $banner = Banner::find(request()->input('id'));            
            $banner->delete();
            Upload::removeFile('banner_ru', $banner->id);
            Upload::removeFile('banner_uz', $banner->id);

			$response = [
				'status' => 'success',
				'message' => __('alert.success.delete')
			];
		} else {
			$response = [
				'status' => 'error',
				'message' => 'Пожалуйста попробуйте снова'
			];
		}
		
		return response()->json($response);
    }
    
    public function status()
    {
        $id = request()->id;
        $banner = Banner::find($id);
        if ($banner->status == 1) {
            $status = 0;
        } else {
            $status = 1;
        }
        $banner->update(['status' => $status]);
        return response()->json(['status' => $status]);
    }
}
